// ----------------------------------------------------------------------------
// qrss.h  --  VERY LONG DURATION morse code modem
//
// Copyright (C) 2006-2009
//		Dave Freese, W1HKJ
//
// This file is part of fldigi.  Adapted in part from code contained in 
// gmfsk source code distribution.
//  gmfsk Copyright (C) 2001, 2002, 2003
//  Tomi Manninen (oh2bns@sral.fi)
//  Copyright (C) 2004
//  Lawrence Glaister (ve7it@shaw.ca)
//
// Fldigi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fldigi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fldigi.  If not, see <http://www.gnu.org/licenses/>.
// ----------------------------------------------------------------------------

#ifndef _QRSS_H
#define _QRSS_H

#include <cstring>
#include <string>

#include <config.h>

#include "modem.h"
#include "filters.h"
#include "fftfilt.h"
#include "mbuffer.h"

#define	QRSS_SAMPLERATE   8000
#define SFFT_SIZE         8000

#define QRSS_F0           600
#define QRSS_HZPERBIN     (( QRSS_SAMPLERATE) / (1.0 * SFFT_SIZE))

#define QRSS_BW2 400
#define NUM_BINS (QRSS_BW2 * 2)

#define FIRST_BIN ((int)(QRSS_F0/(QRSS_HZPERBIN)) - QRSS_BW2)
#define LAST_BIN  (FIRST_BIN + NUM_BINS)

class qrss : public modem {

protected:
	int			symbollen;		// length of a dot in sound samples (tx)

	double		qrss_phase;		// used by NCO for rx/tx tones
	double		qsk_phase;

	cmplx		sfft_bins[NUM_BINS];
	Cmovavg		*binfilter[NUM_BINS];
	double		bins[NUM_BINS];
	sfft		*qrss_filter;

// user configurable data - local copy passed in from gui
	float qrss_speed;

	long int qrss_dot_length;			// Length of a send Dot, in Usec 

	double qrssbuf[OUTBUFSIZE];
	double qskbuf[OUTBUFSIZE];			// signal array for qsk drive

	cmplx mixer(cmplx);

	double nco(double freq);
	double qsknco();

	void send_symbol(int, long);
	void send_tones(int);

public:
	qrss();
	~qrss();
	void	init();
	void	rx_init();
	void	tx_init();
	void	restart(){}

	int		rx_process(const double *, int);
	void	rx_sfft(const double *, int);

	int		tx_process();

	double 	*qrss_bins() { return bins; }
};

void open_qrss_KEYLINE();
void close_QRSS_KEYLINE();

void qrssio_key(int);
void qrssio_ptt(int);
double qrssio_now();
void qrssio_bit(int, double);
void send_qrssio(int);
void start_qrssio_thread(void);
void stop_qrssio_thread(void);
void * qrssio_loop(void *args);

void send_via_keyline(int);

#endif
