// ----------------------------------------------------------------------------
// hwfall_viewer - horizontal waterfall / spectrum view for long duration modes
//
// Copyright (C) 2006-2010
//		Dave Freese, W1HKJ
//		   (C) Mauri Niininen, AG1LE
//
// This file is part of fldigi.  Adapted from code contained in gmfsk source code
// distribution.
//  gmfsk Copyright (C) 2001, 2002, 2003
//  Tomi Manninen (oh2bns@sral.fi)
//  Copyright (C) 2004
//  Lawrence Glaister (ve7it@shaw.ca)
//
// Fldigi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fldigi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fldigi.  If not, see <http://www.gnu.org/licenses/>.
// ----------------------------------------------------------------------------

#ifndef hwfall_viewer_h
#define hwfall_viewer_h
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Counter.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Light_Button.H>

#include "hwfall.h"

extern hwfall *hwfall_wfall;

extern Fl_Double_Window* create_hwfall_viewer();
extern Fl_Counter* hwfall_viewer_range;
extern Fl_Counter* hwfall_viewer_min_db;
extern Fl_Counter* hwfall_waterfall_speed;
extern Fl_Choice*  hwfall_viewer_palette;
extern Fl_Button*  btn_hwfall_clear_display;
extern Fl_Light_Button* btn_pause_display;

//extern void hwfall_data_update(double *, int);

extern Fl_Double_Window *hwfall_viewer;

extern void hwfall_init();
extern int hwfall_viewer_rx_process(const double *buf, int len);

#endif
